/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.commandline.launcher;

import com.aptana.commandline.launcher.CommandlineLauncherPlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.resources.IProjectContext;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.FileUtil;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.WorkbenchJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandlineArgumentsHandler {
    public static List<File> processCommandLineArgs(final String[] arguments) {
        if (arguments == null || arguments.length == 0) {
            return Collections.emptyList();
        }
        final List files = FileUtil.gatherFilesFromCommandLineArguments((String[])arguments);
        WorkbenchJob workbenchJob = new WorkbenchJob("Processing command line args."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)arguments.length);
                for (File f : files) {
                    CommandlineArgumentsHandler.processArgument(f, (IProgressMonitor)sub.newChild(1));
                }
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)workbenchJob);
        workbenchJob.setPriority(10);
        workbenchJob.schedule();
        return files;
    }

    protected static void processArgument(File file, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            CommandlineArgumentsHandler.processFile(file, (IProgressMonitor)sub.newChild(1));
        } else if (file.isDirectory()) {
            CommandlineArgumentsHandler.processDirectory(file, (IProgressMonitor)sub.newChild(1));
        }
    }

    protected static void processDirectory(File file, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)130);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        File dotProject = new File(file, ".project");
        String projectName = null;
        IProjectDescription description = null;
        if (dotProject.isFile()) {
            try {
                description = workspace.loadProjectDescription(Path.fromOSString((String)dotProject.getAbsolutePath()));
                projectName = description.getName();
            }
            catch (CoreException e) {
                IdeLog.logWarning((Plugin)CommandlineLauncherPlugin.getDefault(), (Throwable)e);
            }
        }
        if (description == null) {
            projectName = dotProject.getParentFile().getName();
            description = workspace.newProjectDescription(projectName);
            IPath locationPath = Path.fromOSString((String)dotProject.getParent());
            if (Platform.getLocation().isPrefixOf(locationPath)) {
                description.setLocation(null);
            } else {
                description.setLocation(locationPath);
            }
        }
        sub.worked(15);
        try {
            boolean forceAsActive = false;
            IProject project = workspace.getRoot().getProject(projectName);
            if (!project.exists()) {
                project.create(description, (IProgressMonitor)sub.newChild(30));
                forceAsActive = true;
            }
            sub.setWorkRemaining(85);
            if (project.isOpen()) {
                forceAsActive = true;
            } else {
                project.open(128, (IProgressMonitor)sub.newChild(70));
            }
            sub.setWorkRemaining(15);
            if (forceAsActive) {
                CommandlineArgumentsHandler.setActiveProject(project);
            }
        }
        catch (CoreException e) {
            IdeLog.logWarning((Plugin)CommandlineLauncherPlugin.getDefault(), (Throwable)e);
        }
    }

    protected static void setActiveProject(final IProject project) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                IViewReference[] refs;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                IWorkbenchPage page = window.getActivePage();
                if (page == null) {
                    return;
                }
                IViewReference[] iViewReferenceArray = refs = page.getViewReferences();
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference ref = iViewReferenceArray[n2];
                    IWorkbenchPart view = ref.getPart(false);
                    if (view instanceof IProjectContext) {
                        IProjectContext pc = (IProjectContext)view;
                        pc.setActiveProject(project);
                        return;
                    }
                    ++n2;
                }
            }
        });
    }

    protected static void processFile(File file, IProgressMonitor monitor) {
        IPath path = Path.fromOSString((String)file.getAbsolutePath());
        IFile fileForLocation = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor editorDescriptor = null;
        if (fileForLocation == null) {
            IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(file.getName());
            editorDescriptor = editorRegistry.getDefaultEditor(file.getName(), contentType);
        } else {
            editorDescriptor = editorRegistry.getDefaultEditor(file.getName());
        }
        String editorId = editorDescriptor == null ? "com.aptana.editor.text" : editorDescriptor.getId();
        try {
            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (URI)file.toURI(), (String)editorId, (boolean)true);
        }
        catch (PartInitException e) {
            IdeLog.logWarning((Plugin)CommandlineLauncherPlugin.getDefault(), (Throwable)e);
        }
    }
}

